<?php
if (session_status() == PHP_SESSION_NONE) {
    session_set_cookie_params(10800);
    session_start();
}
$counterstand = intval(file_get_contents("counter.txt"));
if(!isset($_SESSION['app_counter']))
{
    $counterstand++;
    file_put_contents("counter.txt", $counterstand);
    $_SESSION['app_counter'] = true;
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <link rel="stylesheet" type="text/css" href="css/app.css" />
    <script type="text/javascript">
/*<![CDATA[*/
YII_CSRF_TOKEN='e0abaaae6e21c31157a863f71f986a01bf675771';
/*]]>*/
</script>
    <title>Croque Bistro Wedel App Page</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="robots" content="noindex, nofollow">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <script type="text/javascript">
        window.GLOBAL_CSRF_TOKEN = 'e0abaaae6e21c31157a863f71f986a01bf675771';
    </script>

    <!--Facebook meta-->
    <meta property="og:url"
          content="https://croque-bistro.de/index.php?trackSharing=1"/>
    <meta property="og:title" content=""/>
    <meta property="og:description"
          content=""/>
    <meta property="og:image" content="https://croque-bistro.de/img/cropped-logo_icon.png"/>
    <meta property="og:image:width" content="200"/>
    <meta property="og:image:height" content="200"/>

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:url" content="https://croque-bistro.de/app/index.php?trackSharing=1">
    <meta name="twitter:title" content="">
    <meta name="twitter:description"
          content="">
    <meta name="twitter:image" content="https://croque-bistro.de/img/cropped-logo_icon.png">
    <meta name="twitter:image:width" content="200">
    <meta name="twitter:image:height" content="200">

    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="">
    <meta itemprop="description"
          content="">
    <meta itemprop="image" content="https://croque-bistro.de/img/cropped-logo_icon.png">
</head>
<body ng-app="app" id="dvideo-body" ng-controller="ComplexController" class="sh-body" ng-style="getBodyStyles()">

<div class="loading-welcome active welcome-screen"
     ng-style="{'background-color': view.code.welcome_extra.background || view.welcome_extra.background}"
     style="background-color: #ffffff">
    <div class="progress">
        <div class="loading-bar indeterminate" ng-style="{'background-color': view.code.color1 || view.color1}"></div>
    </div>
    <div class="helper"></div>
    <img id="welcomeImg" imageonload ng-src="{{view.welcome_screen || 'https://croque-bistro.de//app/img/welcome.png'}}"
         ng-style="{
            'max-width': view.code.welcome_extra.zoom *2 || view.welcome_extra.zoom *2 + 'px',
            'max-height': view.code.welcome_extra.zoom *2 || view.welcome_extra.zoom *2 + 'px',
            'animation-iteration-count' :  view.showPreview == 'infinite' ? 'infinite' : '',
            'animation-direction' :  view.showPreview == 'infinite' ? 'alternate' : ''
            }">
</div>

<div class="sh-bar" ng-hide="view.code.directLinking == 1">
    <div class="sh-container" style="position: relative;">
        <i class="sh-bar__share icon icon-event-share" id="share-fab-button"></i>
        <div class="sh-bar__name">{{ view.code.name }}</div>
        <div class="sh-bar__company" ng-show="view.code.company">{{ view.code.company }}</div>
    </div>
</div>

<div class="sh-background" ng-style="getBackgroundStyles()" ng-hide="view.code.directLinking == 1"></div>

<div class="sh-container" id="rootElement"><!-- rootElement is important for sync data -->
    <div ng-hide="hasAnyContentToDisplay() || view.code.directLinking == 1">
        <div class="vcard-row text-center mt-20">
            <h4>Warten auf die Eingabe Ihrer Kontaktdaten</h4>
        </div>
        <div class="sk-three-bounce">
            <div class="sk-child sk-bounce1"></div>
            <div class="sk-child sk-bounce2"></div>
            <div class="sk-child sk-bounce3"></div>
        </div>
    </div>
    <div ng-show="hasAnyContentToDisplay() && view.code.directLinking != 1">
        <div class="sh-page">

            <img class="sh-avatar" ng-src="{{ view.code.avatar }}" data-test="avatar" alt="" ng-show="view.code.avatar">

            <div class="sh-page__title" data-test="title">{{ view.code.title }}</div>

            <div class="sh-page__description" ng-show="view.code.description.length <= 70"><!--
        --><span class="sh-page__description-text" data-test="description">{{ view.code.description }}</span>
            </div>

            <div class="sh-page__description" ng-show="view.code.description.length > 70 && showDescription"><!--
        --><span class="sh-page__description-text">{{ view.code.description }}</span>&nbsp;<!--
        --><span class="sh-page__less" ng-click="showDescription = false">Weniger</span>
            </div>

            <div class="sh-page__description" ng-show="view.code.description.length > 70 && !showDescription"><!--
        --><span class="sh-page__description-text">{{ view.code.description | limitTo:70 }}&hellip;</span>&nbsp;<!--
        --><span class="sh-page__more" ng-click="showDescription = true">Mehr</span>
            </div>

            <div ng-show="view.code.button.label">
                <a class="sh-button"
                   ng-style="{borderColor: getBorderColor1()}"
                   href="{{ view.code.button.url }}"
                   target="_blank"
                   ng-click="callAction($event, 'button')">
                    {{ view.code.button.label }}
                </a>
            </div>

            <div ng-show="view.code.app_store">
                <a class="sh-store-link" href="{{ view.code.app_store }}" target="_blank" ng-click="callAction($event, 'appStore')">
                    <img class="sh-store-link__image" src="img/apple-de.png" alt="">
                </a>
            </div>

            <div ng-show="view.code.play_store">
                <a class="sh-store-link" data-test="google-play-link" href="{{ view.code.play_store }}" target="_blank" ng-click="callAction($event, 'appStore')">
                    <img class="sh-store-link__image" src="img/google-de.png" alt="">
                </a>
            </div>

            <div ng-show="view.code.amazon_store">
                <a class="sh-store-link" href="{{ view.code.amazon_store }}" target="_blank" ng-click="callAction($event, 'appStore')">
                    <img class="sh-store-link__image" src="img/amazon-de.png" alt="">
                </a>
            </div>

            <div ng-show="view.code.website" class="sh-page__website-container">
                <a class="sh-page__website" href="{{ view.code.website | normalizeUrl }}" target="_blank" ng-style="{color: getTextColor2()}">
                    {{ view.code.website | domain }}
                </a>
            </div>

        </div>
        <div id="redirectTo">
            <div class="fixed-blur-bgd">
                <div class="dialog-container">
                    <div class="fab-body">
                        <div class="event-title">
                            Im Browser öffnen?                </div>
                        <div class="dialog-body">
                            Fortfahren? Sie werden zu einer anderen Webseite weitergeleitet.                </div>
                        <a class="event-slim-button ripplelink mt-10 pull-right" ng-style="{color: isColorLight(view.code.color2) ? 'black' : view.code.color2}"
                           ng-click="dialogRedirectCallback(false)">
                            Nein                </a>
                        <a class="event-slim-button ripplelink mt-10 pull-right" ng-style="{color: isColorLight(view.code.color2) ? 'black' : view.code.color2}"
                           ng-click="dialogRedirectCallback(true)">
                            Ja                </a>
                    </div>
                </div>
            </div>
        </div>

        <div id="gotIt">
            <div class="fixed-blur-bgd">
                <div class="dialog-container">
                    <div class="fab-body">
                        <div class="event-gotIt-button">
                        </div>
                        <div class="dialog-body pull-left">
                            {{ gotItText }}
                        </div>
                        <a class="text-regular-blue mt-20" ng-click="closeDialog()">
                            Ok, verstanden                </a>
                    </div>
                </div>
            </div>
        </div>

        <div id="redirectToMaps">
            <div class="fixed-blur-bgd">
                <div class="dialog-container">
                    <div class="fab-body">
                        <div class="event-title">
                            Google Maps nutzen                </div>
                        <div class="dialog-body">
                            Route wird in Google Maps geöffnet.                    Wollen Sie fortfahren?                </div>
                        <a class="event-slim-button ripplelink mt-10 pull-right"
                           ng-style="{color: isColorLight(view.code.color2) ? 'black' : view.code.color2}"
                           ng-click="dialogRedirectCallback(false)">
                            Nein                </a>
                        <a class="event-slim-button ripplelink mt-10 pull-right"
                           ng-style="{color: isColorLight(view.code.color2) ? 'black' : view.code.color2}"
                           ng-click="dialogRedirectCallback(true, 'https://maps.google.com/maps?saddr='+getMapAddress()+'&daddr=')">
                            Ja                </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="fabs" id="shareFab2">
            <div class="fixed-blur-bgd">
                <div class="chat">
                    <div class="fab-body">
                        <div class="icon-fab-close icon-event-close" data-test="share-external-modal-close-button"></div>
                        <div class="fab-header" ng-style="{color: view.code.color2}">Diese Seite teilen</div>
                        <ul>
                            <li>
                                <i class="icon-fab-share-facebook icon-event-facebook"></i>
                                <a data-test="share-external-modal-option" href="https://www.facebook.com/sharer/sharer.php?u=https://croque-bistro.de/app/index.php?trackSharing=1" target="_blank">Facebook</a>
                            </li>
                            <li>
                                <i class="icon-fab-share-twitter icon-event-twitter"></i>
                                <a data-test="share-external-modal-option" href="https://twitter.com/share?url=https://croque-bistro.de/app/index.php?trackSharing=1" target="_blank">Twitter</a>
                            </li>
                            <li>
                                <i class="icon-fab-share-email icon-event-email"></i>
                                <a data-test="share-external-modal-option" href="mailto:?body=https://croque-bistro.de/app/index.php?trackSharing=1" target="_blank">Email</a>
                            </li>
                            <li>
                                <i class="icon-fab-share-message icon-event-message"></i>
                                <span id="shortUrl" style="display: none;">https://croque-bistro.de/app/index.php?trackSharing=1</span>
                                <a href="#" id="copyButton1">
                                    Copy Link
                                    <span ng-show="ifCopySucceed">
                                (Kopiert)
                            </span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="sh-cody" ng-show="view.code.directLinking == 1">
        <div class="sh-cody__message">
            Für diesen QR Code steht keine Live-Vorschau zur Verfügung. Sie können den Code aber im nächsten Schritt testen.            </div>
        <img class="sh-cody__image" src="img/CodyE_PointingLeft.svg">
    </div>

</div>

<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/angular.rendering.min.js"></script>
<script type="text/javascript">
/*<![CDATA[*/

    /**
     * Angular connection
     */
    app.loadBasePreviewController();

    /**
     * Return value with '-' instead of spaces
     *
     * @param input - string
     * */
    app.filter('dashEncode', function () {
        return function (input) {
            if (input) {
                return input.replace(/ /g, "-");
            } else
                return ' ';
        };
    });

    /**
     * The QR service for the app.
     * */
    app.service('qr', function () {
        /**
         * Scroll page from buttom to top
         * */
        this.scrollFromBottomtoTop = function (loadDemo) {
            setTimeout(function () {
                if (loadDemo == true && $('.icon-business-socialmedia').length > 0) {
                    $("html, body").animate({
                        scrollTop: $('.icon-business-socialmedia').offset().top
                    }, 0)
                    ;$("html, body").animate({
                        scrollTop: 0
                    }, 1000);
                }
            }, 0)
        }
    });

    /**
     * Directive
     *
     * When image is loaded fadeout welcome screen
     * */
    app.directive('imageonload', ['qr', function (qr) {
        return {
            restrict: 'A',
            link: function (scope, element, attrs) {
                element.bind('load', function () {
                    $("#welcomeImg").fadeIn(1000);
                    window.setTimeout(function () {
                        $(".loading-welcome.welcome-screen").fadeOut();
                        scope.welcomeScreenScrollWindow++;
                        if (scope.welcomeScreenScrollWindow == 1) {
                            qr.scrollFromBottomtoTop(scope.loadDemo)
                        }
                    }, 2000);
                });
                element.bind('error', function () {
                });
            }
        };
    }]);

    app.filter('normalizeUrl', function () {
        return function (url) {
            if (!url) {
                return url;
            }
            if (/^https?:\/\//i.test(url)) {
                return url;
            }
            return 'http://' + url;
        };
    });

    app.filter('displayUrl', function () {
        return function (url) {
            if (!url) {
                return url;
            }
            if (/^http:\/\//i.test(url)) {
                return url.substr(7);
            }
            if (/^https:\/\//i.test(url)) {
                return url.substr(8);
            }
            return url;
        };
    });

    /**
     * Return domain of input
     * */
    app.filter('domain', function () {
        return function (input) {
            if (input) {
                if (input.indexOf('://') >= 0) {
                    return input.split('/')[2]
                }
                return input.split('/')[0]
            }
            return input;
        };
    });

    app.directive('pictureInput', ['$log', function ($log) {
        return {
            restrict: 'A',
            link: function (scope, element) {
                element.on('change', function () {
                    var el = element[0];
                    if ("files" in el && el.files.length > 0) {
                        var file = el.files[0];
                        $log.debug("Got picture type: " + file.type);
                        if (/^image\//.test(file.type)) {
                            $log.debug("Reading picture... [type: " + file.type + ", size: " + file.size + "]");
                            var reader = new FileReader();
                            reader.onload = function () {
                                $log.debug("Reading is done [" + ('' + reader.result).substr(0, 30) + "...]");
                                scope.setPicture(reader.result);
                                scope.$apply();
                            };
                            reader.readAsDataURL(file);
                        }
                    } else {
                        scope.setPicture('');
                        scope.isTakingPictureAvailable = false;
                        scope.$apply();
                    }
                });
            }
        };
    }]);

    //Override the base preview controller
    app.controller('ComplexController', function ($scope, $controller, $sce, $rootScope, $filter, previewService, $window, $log, http, $timeout) {
            /**
             * Current page state
             */
            $scope.page = {
                form: {
                    email: ''
                }
            };

            $scope.welcomeScreenScrollWindow = 0;
            $scope.isDialogVisible = false;
            $scope.showDescription = false;

            /**
             * @returns {boolean}
             */
            $scope.hasAnyContentToDisplay = function () {
                return true;
            };

            $scope.getBodyStyles = function () {
                if (!$scope.view.code) {
                    return {};
                }
                if ($scope.view.code && $scope.view.code.directLinking === 1) {
                    return {
                        background: '#fff',
                        color: '#797d80'
                    };
                }
                return {
                    color: $scope.getTextColor1()
                };
            };

            /**
             * Get background gradient color.
             */
            $scope.getBackgroundStyles = function () {
                if (!$scope.view.code) {
                    return {};
                }
                if (!$scope.view.code.color2) {
                    return {
                        backgroundImage: "linear-gradient(to bottom," + $scope.view.code.color1 + ", " + $filter('colorLuminance')($scope.view.code.color1, -0.2) + " 100%)",
                        color: $scope.getTextColor1()
                    };
                }
                return {
                    backgroundImage: "linear-gradient(to bottom, " + $scope.view.code.color1 + ", " + $scope.view.code.color2 + ")",
                    color: $scope.getTextColor1()
                };
            };

            /**
             * Get the text color #1.
             * Depends on color1 brightness.
             * @returns {string}
             */
            $scope.getTextColor1 = function () {
                if (!$scope.view.code) {
                    return '#fff';
                }
                return $scope.isColorLight($scope.view.code.color1) ? '#333' : '#fff';
            };

            /**
             * Get the border color #1.
             * Depends on color1 brightness.
             * @returns {string}
             */
            $scope.getBorderColor1 = function () {
                if (!$scope.view.code) {
                    return 'rgba(255, 255, 255, 0.7)';
                }
                return $scope.isColorLight($scope.view.code.color1) ? 'rgba(0, 0, 0, 0.54)' : 'rgba(255, 255, 255, 0.7)';
            };

            /**
             * Get the text color #2.
             * Depends on color2 brightness.
             * @returns {string}
             */
            $scope.getTextColor2 = function () {
                if (!$scope.view.code) {
                    return '#fff';
                }
                return $scope.isColorLight($scope.view.code.color2) ? '#333' : '#fff';
            };

            /**
             * Copy short ulr to clipboard
             *
             * @param elem - input element with the link
             * */
            $scope.ifCopySucceed = false;
            $scope.copyLinkToClipboard = function (elem) {
                var targetId = "_hiddenCopyText_";
                var isInput = elem.tagName === "INPUT" || elem.tagName === "TEXTAREA";
                var origSelectionStart, origSelectionEnd;
                if (isInput) {
                    // can just use the original source element for the selection and copy
                    target = elem;
                    origSelectionStart = elem.selectionStart;
                    origSelectionEnd = elem.selectionEnd;
                } else {
                    // must use a temporary form element for the selection and copy
                    target = document.getElementById(targetId);
                    if (!target) {
                        var target = document.createElement("textarea");
                        target.style.position = "absolute";
                        target.style.left = "-9999px";
                        target.style.top = "0";
                        target.id = targetId;
                        document.body.appendChild(target);
                    }
                    target.textContent = elem.textContent;
                }
                // select the content
                var currentFocus = document.activeElement;
                target.focus();
                target.setSelectionRange(0, target.value.length);

                // copy the selection
                var succeed;
                try {
                    succeed = document.execCommand("copy");
                } catch (e) {
                    succeed = false;
                }
                // restore original focus
                if (currentFocus && typeof currentFocus.focus === "function") {
                    currentFocus.focus();
                }

                if (isInput) {
                    // restore prior selection
                    elem.setSelectionRange(origSelectionStart, origSelectionEnd);
                } else {
                    // clear temporary content
                    target.textContent = "";
                }
                $scope.$apply(function () {
                    $scope.ifCopySucceed = succeed;
                });
                setTimeout(function () {
                    $scope.$apply(function () {
                        $scope.ifCopySucceed = false;
                    });
                }, 1500)
            };

            /**
             * Open the dialog popup
             * Event is for getting the current target element
             * Target:
             *      - shareAction: Button with got it information
             *      - channelAction: Button with got it information
             *
             * @param event - string
             * @param target - string
             * */
            $scope.callAction = function (event, target) {
                switch (target) {
                    case 'callAction':
                        event.preventDefault();
                        if ($scope.loadDemo) {
                            $scope.gotItText = 'Benennen Sie diesen optionalen Button wie Sie möchten und verlinken auf eine Webseite Ihrer Wahl.';
                            $scope.toggleDialog('gotIt', $(event.currentTarget));
                        } else {
                            $scope.toggleDialog('redirectTo');
                        }
                        break;
                    case 'shareAction':
                        if ($scope.loadDemo) {
                            $scope.gotItText = 'Nutzer können den Button antippen um Ihre Seite zu teilen.';
                            $scope.toggleDialog('gotIt', $(event.currentTarget));
                        }
                        break;
                    case 'shareAction2':
                        if ($scope.loadDemo) {
                            toggleFab('#shareFab');
                            event.preventDefault();
                            $scope.gotItText = 'Besucher können Ihre Seite über diesen Button teilen.';
                            $scope.toggleDialog('gotIt', $(document.getElementById('prime')));
                        }
                        break;
                    case 'button':
                        if ($scope.loadDemo) {
                            event.preventDefault();
                            $scope.gotItText = 'Durch Antippen dieses (optionalen) Buttons gelangen Nutzer zu einer Webseite Ihrer Wahl.';
                            $scope.toggleDialog('gotIt', $(event.currentTarget));
                        }
                        break;
                    case 'appStore':
                        if ($scope.loadDemo) {
                            event.preventDefault();
                            $scope.gotItText = 'Hier gelangen Nutzer zum jeweiligen App Store, um Ihre App herunterzuladen.';
                            $scope.toggleDialog('gotIt', $(event.currentTarget));
                        }
                        break;
                }
            };

            $scope.toggleFab = toggleFab;

            /**
             * Toggle dialog
             *
             * @param id - string
             * @param element - current target
             * */
            $scope.toggleDialog = function (id, element) {
                if (element) {
                    var elem = element.context.outerHTML;
                    $('#' + id + ' .dialog-container .event-gotIt-button').html(elem);
                }
                $($('#' + id).parent()).toggleClass('fabOnTop');
                $('#' + id + ' .dialog-container').toggleClass('is-visible');
                $('#prime.fab').toggleClass('disabledClick');
                $('#' + id + ' .fixed-blur-bgd').toggle();
            };

            /**
             * Callback of the dialog yes/no buttons
             * Can close the dialog or it can redirect to a url and close the dialog
             * If the url is not defined it will use the targetUrl from the callAction button
             *
             * @param proceed - string
             * @param url - current target
             * */
            $scope.dialogRedirectCallback = function (proceed, url) {
                if (proceed) {
                    if (url) {
                        $window.open(url, '_blank');
                    } else {
                        if ($scope.view.code.button.url.indexOf('http') < 0)
                            $window.open('//' + $scope.view.code.button.url, '_blank');
                        else
                            $window.open($scope.view.code.button.url, '_blank');
                    }
                    $scope.closeDialog();
                } else {
                    $scope.closeDialog();
                }
            };

            /**
             * Close dialog
             *
             * */
            $scope.closeDialog = function () {
                $('.dialog-container').removeClass('is-visible');
                $('#prime.fab').toggleClass('disabledClick');
                $('.event-gotIt-button').html('');
                $('.fixed-blur-bgd').hide();
            };

            //Inherit from basePreviewController
            // @todo hmm this is not a normal angular inheritance...
            angular.extend(this, $controller('BasePreviewController', {$scope: $scope}));

            $scope.loadDemo = parent && typeof parent.ImHere === "function";

            //Get the json data form the file
            previewService.pushData({"form":[{"section_design":{"fold":false}},{"section_basic_info":{"fold":false}},{"section_links":{"fold":false}},{"section_welcome_screen":{"fold":false}}],"code":{"directLinking":0,"openWindow":false,"avatar":"\/\/croque-bistro.de\/img\/cropped-logo_icon.png","color1":"#3c4245","color2":"#5a6368","app_store":"https:\/\/apps.apple.com\/de\/app\/croque-bistro-wedel\/id1499632332","play_store":"https:\/\/play.google.com\/store\/apps\/details?id=de.simplydelivery.croquebistrowedel&hl=gsw","amazon_store":"","fallbackUrl":"","stores":{"apple":true,"google":true,"amazon":false},"avatar_extra":{"zoom":100,"background":"#ffffff"},"welcome_extra":{"zoom":50,"background":"#ffffff"},"button":{"label":"","url":""},"name":"Croque Bistro","description":"","title":"","website":"Https:\/\/croque-bistro.de\/","company":""},"showPreview":1,"welcome_screen":"\/\/croque-bistro.de\/img\/logo_465x320.png"});

            /**
             * Watch showPreview value
             *
             * @param p1 - new value
             * @param p2 - old value
             * */
            $scope.$watch("view.showPreview", function (p1, p2) {
                if (p1 != undefined && p1 == 'infinite') {
                    setTimeout(function () {
                        $(".loading-welcome.welcome-screen").show();
                        $("#welcomeImg").fadeIn(1000);
                    }, 500)
                } else if (p1 == undefined && p2 != undefined && p2 == 'infinite') {
                    $("#welcomeImg").hide();
                    $(".loading-welcome").fadeOut();
                } else if ((p1 != undefined && p2 != undefined && p1 != p2 ) || (p1 != undefined && p1 != 0 && p2 == undefined && p1 != p2)) {
                    setTimeout(function () {
                        $(".loading-welcome.welcome-screen").show();
                        $("#welcomeImg").hide();
                        $("#welcomeImg").fadeIn(1000);
                        setTimeout(function () {
                            $(".loading-welcome").fadeOut();
                        }, 2000)
                    }, 500)
                }
            });

            // To sync the height of the page and the content in design mode.
            $scope.$watch('view.code', function () {
                setTimeout(function () {
                    $(window).resize();
                }, 100);
            });

            $(document).ready(function () {
                /**
                 * To work, function 'copyLinkToClipboard' needs to be called from an event listener on the copy button
                 * */
                document.getElementById("copyButton1").addEventListener("click", function (event) {
                    if (event) {
                        event.preventDefault();
                    }
                    $scope.copyLinkToClipboard(document.getElementById("shortUrl"));
                });
            });

            /**
             * Convert hex color to rgbA
             *
             * @param hex - color
             * @param opacity - value between 0-1
             * */
            $scope.hexToRgbA = function (hex, opacity) {
                var c;
                if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)) {
                    c = hex.substring(1).split('');
                    if (c.length == 3) {
                        c = [c[0], c[0], c[1], c[1], c[2], c[2]];
                    }
                    c = '0x' + c.join('');
                    return 'rgba(' + [(c >> 16) & 255, (c >> 8) & 255, c & 255].join(',') + ',' + opacity + ')';
                }
            };

            /**
             * Set text color based on the background
             *
             * @param color - background color
             * */
            $scope.isColorLight = function (color) {
                var c;
                if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(color)) {
                    c = color.substring(1).split('');
                    if (c.length == 3) {
                        c = [c[0], c[0], c[1], c[1], c[2], c[2]];
                    }
                    c = '0x' + c.join('');

                    var r = (c >> 16) & 255,
                        g = (c >> 8) & 255,
                        b = c & 255;
                    // Counting the perceptive luminance
                    // human eye favors green color...
                    var a = 1 - (0.240 * r + 0.470 * g + 0.150 * b) / 255;
                    return (a < 0.4);
                }
            };

        }
    );

    if (parent && typeof parent.ImHere === "function") {
        parent.ImHere();
    } else {
        //Only load this on standalone pages not inframe working
        SocialShareKit.init();
    }

    /**
     * Toggle fab
     *
     * @param id - id of the fab
     */
    function toggleFab(id) {
        $(id + ' .prime').toggleClass('is-active');
        $(id + ' #prime').toggleClass('is-float');
        $($(id).parent()).toggleClass('fabOnTop');
        $('#prime.fab').toggleClass('disabledClick');
        $(id + ' .fixed-blur-bgd').toggle();
        $(id + ' .chat').toggleClass('is-visible');
    }

    $(document).ready(function () {
        $('#prime, .icon-event-close').click(function () {
            var id = $($(this).closest('.fabs')).attr('id');
            toggleFab('#' + id);
        });

        $('#share-fab-button').click(function () {
            toggleFab('#shareFab2');
        });

        $('.fixed-blur-bgd').click(function (event) {
            if (event.target == $(this)[0]) {
                $($("#prime.is-float").parent().parent()).removeClass('fabOnTop');
                $('.prime').removeClass('is-active');
                $('#prime').removeClass('is-float');
                $('#prime.fab').removeClass('disabledClick');
                $('.chat, .dialog-container').removeClass('is-visible');
                $(this).hide();
            }
        });

        // To fix height of the background (CSS does not work for some reason)
        $(window).resize(function () {
            $(".sh-page").height("auto");
            var height = Math.max($(".sh-bar").outerHeight() + $("#rootElement").outerHeight(), $(window).height());
            $(".sh-background").height(height);
            if ($(window).width() < 480) {
                $(".sh-page").height(height - $(".sh-bar").outerHeight() - 20);
            }
        });
        $(window).scroll(function () {
            $(".sh-background").height(Math.max($(".sh-bar").outerHeight() + $("#rootElement").outerHeight(), $(window).height()));
        });
        setTimeout(function () {
            $(window).resize();
        }, 1000);
        // -------------------------------

        /**
         * Ripple effect on element
         */
        var ink, d, x, y;
        $(".ripplelink").click(function (e) {
            if ($(this).find(".ink").length === 0) {
                $(this).prepend("<span class='ink'></span>");
            }

            ink = $(this).find(".ink");
            ink.removeClass("animate");

            if (!ink.height() && !ink.width()) {
                d = Math.max($(this).outerWidth(), $(this).outerHeight());
                ink.css({height: d, width: d});
            }

            x = e.pageX - $(this).offset().left - ink.width() / 2;
            y = e.pageY - $(this).offset().top - ink.height() / 2;

            ink.css({top: y + 'px', left: x + 'px'}).addClass("animate");
        });

    });


/*]]>*/
</script>
</body>
</html>
